#ifndef SST_SEP_ATP_SPECIALDATAOPRSA_H
#define SST_SEP_ATP_SPECIALDATAOPRSA_H

#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

/************************ Structs  ******************************/
typedef struct TST_ATP_SpecialDataOpRSATestDataStruct{
    DxChar                      TST_Name[TST_NAME_STRING_LEN];
    /*Challenge key*/
    DxUint32_t                  TST_ChalengeKeySizeInBytes;
    DxByte_t                    TST_N[TST_N_SIZE_BYTES];
    DxByte_t                    TST_D[TST_N_SIZE_BYTES];
    DxByte_t                    TST_E[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_ChalengeKeyESizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_SignedChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_SignedChallengeBuffSize; 
    /*Key Creation parameters for Keys 1 and 2 */
    DxUint32_t                  TST_Key1SizeInBytes;
    DxByte_t                    TST_E1[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E1SizeInBytes;
    /* Key info buffers for keys 3 and 4 */
    DxByte_t                    TST_N3[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_N3SizeInBytes;
    DxByte_t                    TST_D3[TST_D_SIZE_BYTES];
    DxUint32_t                  TST_D3SizeInBytes;
    DxByte_t                    TST_E3[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E3SizeInBytes;
    DxByte_t                    TST_N4[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_N4SizeInBytes;
    DxByte_t                    TST_D4[TST_D_SIZE_BYTES]; 
    DxUint32_t                  TST_D4SizeInBytes;
    DxByte_t                    TST_E4[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E4SizeInBytes;
    DxByte_t                    TST_P4[TST_P_SIZE_BYTES];
    DxUint32_t                  TST_P4SizeInBytes;
    DxByte_t                    TST_Q4[TST_Q_SIZE_BYTES];
    DxUint32_t                  TST_Q4SizeInBytes;
    DxByte_t                    TST_DP4[TST_DP_SIZE_BYTES];
    DxUint32_t                  TST_DP4SizeInBytes;
    DxByte_t                    TST_DQ4[TST_DQ_SIZE_BYTES];
    DxUint32_t                  TST_DQ4SizeInBytes;
    DxByte_t                    TST_Qinv4[TST_QINV_SIZE_BYTES];
    DxUint32_t                  TST_Qinv4SizeInBytes;
    /* Key info buffers for keys 5 and 6 */
    DxByte_t                    TST_N5[TST_N_SIZE_BYTES];
    DxByte_t                    TST_D5[TST_D_SIZE_BYTES];
    DxByte_t                    TST_E5[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_E5SizeInBytes;
    DxUint32_t                  TST_Key5SizeInBytes;
    DxByte_t                    TST_P5[TST_P_SIZE_BYTES];
    DxByte_t                    TST_Q5[TST_Q_SIZE_BYTES];
    DxByte_t                    TST_DP5[TST_DP_SIZE_BYTES];
    DxByte_t                    TST_DQ5[TST_DQ_SIZE_BYTES];
    DxByte_t                    TST_Qinv5[TST_QINV_SIZE_BYTES];
    /*Data*/ 
    DxByte_t                    TST_DataIn[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint32_t                  TST_DataInSize; 
    DxByte_t                    TST_DataOut[TST_MAX_DATA_VEC_SIZE_IN_BYTES];        
    DxUint16_t                  TST_DataOutSize;
    CRYS_RSA_HASH_OpMode_t    TST_HASHOperationMode;
    DxUint16_t                  TST_SaltLengthSign;
    DxUint16_t                  TST_SaltLengthVerify;
} TST_ATP_SpecialDataOpRSATestDataStruct;
/*****************************************************************************
 * Function Name:
 *  SEPQA_SST_SpecialDataOpRSA
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the Test the insertion, generation, reading, deletion, and usage of a RSA asymmetric key.
 *  
 * Algorithm:       
 *     1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
 *     2.  Create a new session by calling: SST_SessionCreate.
 *     3.  Open a transaction by calling: SST_TransactionStart.
 *     4.  Create a public key authenticator by calling: SST_AuthenticatorPubKeyRSACreate.
 *     5.  Open the authenticator by calling:
 *     i.  SST_AuthenticatorChallengeGet 
 *         ii.  CRYS_RSA_PSS_Sign
 *         iii.  SST_AuthenticationOpen.
 *     6.  Close the transaction by calling: SST_TransactionClose.
 *     7.  Open the authenticator by calling: SST_AuthenticationOpen.
 *     8.  Create a new RSA #1 key by calling: SST_RSAKeyGenerate.
 *     9.  Create a new RSA #2 key by calling: SST_CRTRSAKeyGenerate.
 *     10.  Read the generated RSA key #1 by calling: 
 *          i.  SST_RSAPublicKeyRead.
 *          ii.  SST_RSAPrivateKeyRead.
 *     11.  Read the generated RSA key #2 by calling: 
 *          i.  SST_CRTRSAPublicKeyRead.
 *          ii.  SST_CRTRSAPrivateKeyRead.
 *     12.  Insert an RSA #3 key to the SST by calling:
 *          i.   SST_RSAPublicKeyInsert. 
 *          ii.  SST_RSAPrivateKeyInsert
 *          Using the data received by reading the SST key #1
 *     13.  Insert an RSA #4 key to the SST by calling:
 *          i.   SST_CRTRSAPublicKeyInsert.
 *          ii.  SST_CRTRSAPrivateKeyInsert
 *          Using the data received by reading the SST key #2
 *     14.  Insert RSA #5 key to the SST by calling: SST_RSAPairKeyInsert. Externally generated key pair
 *     15.  Insert RSA #6 (CRT) key to the SST by calling SST_CRTRSAPairKeyInsert. Externally generated key pair
 *     16.  Close the transaction by calling: SST_TransactionClose.
 *     17.  Sign a plain text by using RSA key #1 and calling: CRYS_SST_RSA_PKCS1v15_Sign.
 *     18.  Verify the signature using RSA key #3 and calling: CRYS_SST_RSA_PKCS1v15_Verify.
 *     19.  Sign a plain text by using RSA key #2 and calling: CRYS_SST_RSA_PSS_Sign.
 *     20.  Verify the signature using RSA key #4 and calling: CRYS_SST_RSA_PSS_Verify.
 *     21.  Sign a plain text by using RSA key #5 and calling: CRYS_SST_RSA_PKCS1v15_Sign.
 *     22.  Verify the signature using RSA key #6 and calling: CRYS_SST_RSA_PKCS1v15_Verify.
 *     23.  Sign a plain text by using RSA key #5 and calling: CRYS_SST_RSA_PSS_Sign.
 *     24.  Verify the signature using RSA key #6 and calling: CRYS_SST_RSA_PSS_Verify.
 *     25.  Open a transaction by calling: SST_TransactionStart.
 *     26.  Delete the RSA keys (one by one) by calling: SST_DataDelete.
 *     27.  Close the authenticator by calling: SST_AuthenticationClose.
 *     28.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *     29.  Close the transaction by calling: SST_TransactionClose.
 *     30.  Delete the session by calling: SST_SessionDelete.
 *******************************************************************************/    
DxError_t SEPQA_SST_SpecialDataOpRSA ( void );



#ifdef __cplusplus
}


#endif

#endif
